package com.snowshoe.ssdemoapp;

import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import com.snowshoe.stampsdk.models.SnowShoeResult;

public class CondoDemoActivity extends AppCompatActivity implements StampFragment.OnFragmentInteractionListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_condo_demo);

    }

    @Override
    public void onFragmentInteraction(Uri uri) {

    }

    @Override
    public void onGetSerialResult(SnowShoeResult result) {
        TextView resultText = findViewById(R.id.text_stamp);
        resultText.setVisibility(View.VISIBLE);
        String serial = "No Stamp Found";
        if (result.getStamp() != null) {
            serial = "Serial: " + result.getStamp().getSerial();
        }
        resultText.setVisibility(View.VISIBLE);
        resultText.setText("Receipt: " + result.getReceipt() + "\n" + serial);

        Log.e("STAMP_DONE: ", "Serial Number Read.");
    }

    @Override
    public void onSyncCompleted(boolean b) {
        TextView resultText = findViewById(R.id.text_sync);
        resultText.setVisibility(View.VISIBLE);
        if (b) {
            resultText.setText("Synced");
        }
        else {
            resultText.setText("Sync failed");
        }
    }
}

