package com.snowshoe.ssdemoapp;

import android.media.Image;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.snowshoe.stampsdk.SnowShoeListener;
import com.snowshoe.stampsdk.SnowShoeView;
import com.snowshoe.stampsdk.models.SnowShoeResult;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class TicketDemoActivity extends AppCompatActivity {

    SnowShoeView stampView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ticket_demo);

        stampView = findViewById(R.id.ssview);
        stampView.setAppKey("INSERT_APPLICATION_KEY");
        stampView.setAppSecret("INSERT_APP_SECRET");
        stampView.setSnowShoeListener(new SnowShoeListener() {
            @Override
            public void onGetSerialResult(SnowShoeResult result) {
                ImageView stampImage = findViewById(R.id.imgview_stamp);
                ImageView successImage = findViewById(R.id.imgview_success);
                TextView resultText = findViewById(R.id.textView);
                String serial = "No Stamp Found";
                if (result.getStamp() != null) {
                    serial = "Serial: " + result.getStamp().getSerial();
                }
                stampImage.setVisibility(View.GONE);
                successImage.setVisibility(View.VISIBLE);
                resultText.setVisibility(View.VISIBLE);
                resultText.setText("Receipt: " + result.getReceipt() + "\n" + serial);

                Log.e("STAMP_DONE: ", "Serial Number Read.");
            }

            @Override
            public void onSyncCompleted(boolean b) {
                TextView resultText = findViewById(R.id.textView);
                resultText.setVisibility(View.VISIBLE);
                resultText.bringToFront();
                String result = resultText.getText().toString();
                if (b) {
                    resultText.setText(result + "\nSynced");
                }
                else {
                    resultText.setText(result + "\nSync failed");
                }
            }
        });
        stampView.syncStampInfo();
    }

}
